/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import java.math.BigDecimal;
import java.security.Principal;

/**
 * A Principal that stores a numeric ID, such as a party ID.
 *
 * @author Sameer Ajmani
 **/
public class PartyPrincipal implements Principal {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/PartyPrincipal.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private BigDecimal m_id;
    /**
     * Creates a new PartyPrincipal that stores the given ID.
     **/
    public PartyPrincipal(BigDecimal id) {
        m_id = id;
    }
    /**
     * Returns the stored ID.
     *
     * @return the stored ID.
     **/
    public BigDecimal getID() {
        return m_id;
    }
    /**
     * Returns the ID number as a string.
     *
     * @return the ID number as a string.
     **/
    public String getName() {
        return m_id.toString();
    }
    /**
     * Same as <code>getName()</code>.
     *
     * @return <code>getName()</code>.
     **/
    public String toString() {
        return getName();
    }
    /**
     * Returns <code>true</code> if the given object is a
     * <code>PartyPrincipal</code> with the same ID.
     *
     * @return <code>true</code> if the given object is a
     * <code>PartyPrincipal</code> with the same ID.
     **/
    public boolean equals(Object that) {
        return (that instanceof PartyPrincipal)
            && this.m_id.equals(((PartyPrincipal)that).m_id);
    }
    /**
     * Returns the <code>hashCode</code> of the stored ID number.
     *
     * @return the <code>hashCode</code> of the stored ID number.
     **/
    public int hashCode() {
        return this.m_id.hashCode();
    }
}
