/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import javax.security.auth.callback.Callback;

/**
 * Callback to determine whether the current login should last "forever" or
 * just until the end of the current session.
 *
 * @author Sameer Ajmani
 **/
public class LifetimeCallback implements Callback {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/LifetimeCallback.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private boolean m_forever;

    /**
     * Return <code>true</code> if the current login should last "forever",
     * <code>false</code> otherwise.
     *
     * @return <code>true</code> if the current login should last "forever",
     * <code>false</code> otherwise.
     **/
    public boolean isForever() {
        return m_forever;
    }

    /**
     * Sets "forever" to the given value.
     *
     * @param forever <code>true</code> if the current login should last
     * "forever", <code>false</code> otherwise.
     **/
    public void setForever(boolean forever) {
        m_forever = forever;
    }
}
