/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;

/**
 * A class that represents a collection of permission records.
 *
 * @author Michael Bryzek
 * @version 1.0
 **/
class PermissionCollection extends DomainCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/PermissionCollection.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see com.arsdigita.domain.DomainCollection#DomainCollection(DataCollection)
     **/
    PermissionCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     * @see com.arsdigita.domain.DomainObject#getDomainObject()
     **/
    public DomainObject getDomainObject() {
        DataObject data = m_dataCollection.getDataObject();
        return new Permission(data);
    }

    /**
     * Wrapper to {@link #getDomainObject()} that casts returned
     * {@link DomainObject} as a <code>Permission</code>.
     *
     * @return A permission for the current position in the
     * collection.
     *
     * @see #getDomainObject()
     * @see ObjectPermission
     **/
    public Permission getPermission() {
        return (Permission) getDomainObject();
    }

}
