/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;

import com.arsdigita.persistence.DataCollection;

/**
 *
 * Represents a collection of Role records.
 *
 * @author Michael Bryzek 
 * @version 1.0
 **/
public class RoleCollection extends DomainCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/RoleCollection.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see com.arsdigita.domain.DomainCollection#DomainCollection(DataCollection)
     **/
    protected RoleCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns a <code>DomainObject</code> for the current position in
     * the collection.
     *
     **/
    public DomainObject getDomainObject() {
        return new Role(m_dataCollection.getDataObject());
    }

    /**
     * Wrapper to {@link #getDomainObject()} that casts the returned
     * {@link DomainObject} as a {@link Role}.
     *
     * @return a {@link Role} for the current position in the
     * collection.
     *
     * @see #getDomainObject()
     **/
    public Role getRole() {
        return (Role) getDomainObject();
    }

}
