/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;

public class PackageTypeCollection extends DomainCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/PackageTypeCollection.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected PackageTypeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    public DomainObject getDomainObject() {
        DomainObject domainObject = getPackageType();

        return domainObject;
    }

    public PackageType getPackageType() {
        DataObject dataObject = m_dataCollection.getDataObject();

        PackageType packageType = new PackageType(dataObject);

        return packageType;
    }
}
