/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.runtime.*;
import com.arsdigita.util.*;
import com.arsdigita.util.parameter.*;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross
 * @see com.arsdigita.kernel.Kernel
 */
public final class KernelConfig extends AbstractConfig {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/kernel/KernelConfig.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(KernelConfig.class);

    private final Parameter m_debug;
    private final Parameter m_permissions;
    private final EnumerationParameter m_identifier; // email or "screenName"?
    private final Parameter m_remember;

    public KernelConfig() {
        m_debug = new BooleanParameter
            ("waf.debug", Parameter.REQUIRED, Boolean.FALSE);

        m_permissions = new BooleanParameter
            ("waf.kernel.data_permission_check_enabled", Parameter.REQUIRED,
             Boolean.TRUE);

        m_identifier = new EnumerationParameter
            ("waf.kernel.primary_user_identifier", Parameter.REQUIRED,
             "email");
        m_identifier.put("email", "email");
        m_identifier.put("screen_name", "screenName");

        m_remember = new BooleanParameter
            ("waf.kernel.remember_login", Parameter.REQUIRED, Boolean.TRUE);

        register(m_debug);
        register(m_permissions);
        register(m_identifier);
        register(m_remember);

        loadInfo();
    }

    public final boolean isDebugEnabled() {
        return ((Boolean) get(m_debug)).booleanValue();
    }

    public final boolean isDataPermissionCheckEnabled() {
        return ((Boolean) get(m_permissions)).booleanValue();
    }

    public final String getPrimaryUserIdentifier() {
        return (String) get(m_identifier);
    }

    // XXX Move this to WebConfig.
    public final boolean isLoginRemembered() {
        return ((Boolean) get(m_remember)).booleanValue();
    }

    /**
     * @deprecated Use
     * <code>Kernel.getConfig().isDataPermissionCheckEnabled()</code>
     * instead
     */
    public static final boolean isPermissionCheckEnabled() {
        return Kernel.getConfig().isDataPermissionCheckEnabled();
    }
}
