/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

public class HashPasswords {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/HashPasswords.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log =
        Logger.getLogger(HashPasswords.class);

    static void hashPasswords() {
        DataCollection dc = SessionManager.getSession()
            .retrieve(UserAuthentication.BASE_DATA_OBJECT_TYPE);
        dc.addEqualsFilter("salt", null);
        for (int i = 1; dc.next(); i ++) {
            s_log.info("HashPasswords: updating user "+i);
            UserAuthentication auth =
                new UserAuthentication(dc.getDataObject());
            auth.hashPassword();
            auth.save();
        }
        dc.close();
    }
}
