/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestValue;
import java.util.Locale;

/**
 * <p>
 * Provides the Locale of an application.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class ApplicationLocaleProvider implements LocaleProvider {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/ApplicationLocaleProvider.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private RequestValue m_locale = new RequestValue();

    public Locale getLocale() {
        return (Locale) m_locale.get(DispatcherHelper.getRequest());
    }

    /**
     * <p>
     * Set the Locale you wish to provide.
     * </p>
     *
     * @param locale, The locale to provide.
     */
    public void setLocale(Locale locale) {
        m_locale.set(DispatcherHelper.getRequest(), locale);
    }
}
