/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.util;


// I am persisting the attributes on XML format and
// retrieve the attributes from this format I use an
// SAX XML parser
import org.xml.sax.InputSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.SAXException;
// Jaxp classes
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

import java.io.StringReader;


// For storing the attributes
import java.util.Map;

import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;

import org.apache.oro.text.perl.Perl5Util;

/**
 * This class is used by the PersistentComponent to
 * convert HTML attributes back and forth between
 * an XML attribute format - one String, stored
 * in the database - and a Java Map key-value format.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/util/AttributeHelper.java#9 $
 *
 */
public class AttributeHelper {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/util/AttributeHelper.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Used during SAX parsing by the DefaultHandler to set the
    // attributes that it finds.
    private com.arsdigita.bebop.util.Attributes m_attributesObject;

    /**
     * Copies attributes from the XML string to the Attributes
     * object
     */
    private DefaultHandler m_attributeHandler =
        new DefaultHandler() {
            public void startElement(String uri,
                                     String localName,
                                     String qName,
                                     Attributes attributes)
                throws SAXException {

                for (int i = 0; i < attributes.getLength(); ++i) {

                    AttributeHelper.this.m_attributesObject
                        .setAttribute((String)attributes.getQName(i),
                                      attributes.getValue(i));
                }
            }
        };

    /**
     * Takes a Bebop Attribute object
     * with the attributes of the Bebop Component and returns those attributes
     * in a String on XML attribute format.
     *
     * @return All attributes on the XML attribute format
     *         key1="value1" key2="value2" ... keyN="valueN"
     */
    public static String
        getAttributeString(com.arsdigita.bebop.util.Attributes attributes) {

        if (attributes == null) {
            return "";
        }

        // This is a contrived way of retrieving the attributes but the upside
        // is that I am not modifying the Bebop code in any way
        ExtendedElement componentElement =
            new ExtendedElement("ignore", "ignore");

        // Export the attributes to the element
        attributes.exportAttributes(componentElement);

        Perl5Util perl = new Perl5Util();

        // Iterate over the attributes and put them in a String on the
        // XML attribute format
        StringBuffer attributeStringBuffer = new StringBuffer();
        java.util.Map attributeMap = componentElement.getAttributes();
        java.util.Iterator attributeNameIterator =
            attributeMap.keySet().iterator();
        while (attributeNameIterator.hasNext()) {
            String attributeName = (String)attributeNameIterator.next();
            String attributeValue = (String)attributeMap.get(attributeName);
            
            Assert.assertTrue(perl.match("/^\\w+$/",
                                         attributeName));            
            attributeValue = StringUtils.quoteHtml(attributeValue);

            attributeStringBuffer.append(attributeName + "=\"" +
                                         attributeValue + "\"");

            // If we are going to add more attributes, delimit with a space
            if (attributeNameIterator.hasNext()) {
                attributeStringBuffer.append(" ");
            }
        }

        return attributeStringBuffer.toString();
    }

    /**
     * Takes a String on XML attribute format and copies the attributes
     * in this String to a Attribute object
     *
     * @param attributeString The String with the XML attributes that we
     *                        are copying from.
     * @param attributesObject The Attribute object of a Bebop Component
     *                         that we are copying to.
     */
    public com.arsdigita.bebop.util.Attributes 
        getAttributesMap(String attributeString) {

        if (attributeString == null || attributeString.equals("")) {
            return new com.arsdigita.bebop.util.Attributes();
        }

        String xmlString = "<dummyElement " + 
            attributeString
            + " />";

        m_attributesObject = new com.arsdigita.bebop.util.Attributes();

        SAXParserFactory saxParserFactory;
        SAXParser saxParser;
        try {

            saxParserFactory = SAXParserFactory.newInstance();
            saxParser = saxParserFactory.newSAXParser();

            // The attribute handler object will copy the attribute values
            // to the HashMap of this AttributeHelper
            saxParser.parse(new InputSource(new StringReader(xmlString)),
                            m_attributeHandler);

        } catch (Exception e) {
            throw new UncheckedWrapperException(e);
        }

        return m_attributesObject;
    }
}
