/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;





import com.arsdigita.bebop.form.RadioGroup;

import com.arsdigita.bebop.parameters.ArrayParameter;

import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.formbuilder.PersistentRadioGroup;



import java.math.BigDecimal;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.formbuilder.PersistentWidget;


public class RadioGroupForm extends OptionGroupForm {
    public RadioGroupForm(String name,
                          SingleSelectionModel form,
                          SingleSelectionModel control) {
        super(name, form, control);
    }

    protected OptionGroup getOptionGroup(String name) {
        return new RadioGroup(new ArrayParameter(name));
    }

    protected PersistentWidget getWidget() {
        return new PersistentRadioGroup();
    }

    protected PersistentWidget getWidget(BigDecimal id)
        throws DataObjectNotFoundException {
        return new PersistentRadioGroup(id);
    }
}
