/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentHeading;
import com.arsdigita.formbuilder.PersistentText;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.globalization.GlobalizedMessage;
import java.math.BigDecimal;


/**
 *  This is the form used to create a persistent heading element
 */
public class HeadingForm extends TextForm {

    public HeadingForm(String name,
                      SingleSelectionModel form,
                      SingleSelectionModel control) {
        super(name, form, control);
    }

    /**
     *  this returns the widget that is used in the "addWidgets" method
     *  can provides subclasses with the ability to use any size desired
     */
    protected Widget getTextWidget(StringParameter parameter) {
        TextField field = new TextField(parameter);
        field.setSize(40);
        return field;
    }

    /**
     *  Subclasses can override this so that it will give the correct
     *  name to the text.
     */
    protected GlobalizedMessage getTextTitle() {
        return GlobalizationUtil.globalize
            ("formbuilder.ui.editors.heading_form_title");
    }

    protected PersistentText getPersistentText() {
        return new PersistentHeading();
    }

    protected PersistentText getPersistentText(BigDecimal id)
        throws DataObjectNotFoundException {
        return new PersistentHeading(id);
    }
}
