/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


// The interface we are implementing
import com.arsdigita.bebop.list.ListModel;

// Classes related to DataObjects
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;

import com.arsdigita.persistence.Filter;

import java.math.BigDecimal;

// These classes should not be in Bebop
import com.arsdigita.util.Assert;


/**
 * List with names and id:s for all SimpleQuestionnaire objects. Those
 * are currently the only objects managed by the Form Builder admin UI.
 *
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/SimpleQuestionnaireListModel.java#7 $
 *
 */
public class SimpleQuestionnaireListModel implements ListModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/SimpleQuestionnaireListModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private DataCollection m_persistedFormsCollection;
    private DataObject m_persistedFormDataObject = null;

    public SimpleQuestionnaireListModel() {

        Session session = SessionManager.getSession();

        m_persistedFormsCollection =
            session.retrieve("com.arsdigita.formbuilder.FormSection");

        // Only fetch the SimpleQuestionnaires
        Filter filter = m_persistedFormsCollection.addFilter("defaultDomainClass = :domainClass");
        filter.set("domainClass", "com.arsdigita.formbuilder.SimpleQuestionnaire");
    }

    /**
     * Indicates if there is a not-null list iten that the
     * getElement() and getKey() methods can use. Will return
     * null before next() is called.
     *
     */
    public boolean listItemNotNull() {

        return m_persistedFormDataObject == null ? false : true;
    }

    public boolean next() {

        boolean nextReturnValue = m_persistedFormsCollection.next();

        // Fetch the DataObject if we are not at the end of the
        // collection
        if (nextReturnValue) {
            m_persistedFormDataObject =
                m_persistedFormsCollection.getDataObject();

            // Doing this since the contract of DataCollection is unclear
            if (m_persistedFormDataObject == null) {
                throw new RuntimeException("FormSection DataCollection " +
                                           "returned a null DataObject");
            }
        }

        return nextReturnValue;
    }

    /**
     * Returns the name of the form
     *
     * @pre listElementNotNull() == true
     * @post return != null
     */
    public Object getElement() {

        assertItemNotNull();

        Object formName = m_persistedFormDataObject.get("adminName");

        // if there is no name - use id instead
        if (formName != null) {
            return formName;
        } else {
            return "questionnaire " + m_persistedFormDataObject.get("id").toString();
        }
    }

    /**
     * Return the id of the form.
     *
     * @pre listElementNotNull() == true
     * @post return != null
     */
    public String getKey() {

        assertItemNotNull();

        // What is the contract of getOID()?
        String id = ((BigDecimal)m_persistedFormDataObject.get("id")).toString();

        Assert.assertNotNull(id);

        return id;
    }

    private void assertItemNotNull() {

        if (m_persistedFormDataObject == null) {
            throw new RuntimeException("next() must be invoked before " +
                                       "this method");
        }
    }
}
