/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.Label;



public class PropertiesForm extends Form {
    SaveCancelSection m_buttons;
    String m_app;

    public PropertiesForm(String name) {
        super(name);

        createWidgets();

        addSubmissionListener(new FormSubmissionListener() {
                public void submitted(FormSectionEvent e)
                    throws FormProcessException {

                    if (m_buttons.getCancelButton().isSelected(e.getPageState()))
                        throw new FormProcessException("Cancel pressed");
                }
            });
    }

    public void setApplication(String app) {
        m_app = app;
    }

    public String getApplication() {
        return m_app;
    }

    protected void createWidgets() {
        addWidgets(this);
        addButtons(this);
    }

    protected void addWidgets(FormSection section) {
    }

    protected void addButtons(FormSection section) {
        m_buttons = new SaveCancelSection();
        section.add(new Label("")); // Padding
        section.add(m_buttons);
    }

    public boolean isComplete(PageState state) {
        return m_buttons.getCancelButton().isSelected(state) ||
            m_buttons.getSaveButton().isSelected(state);
    }

    public boolean isCancelled(PageState state) {
        return m_buttons.getCancelButton().isSelected(state);
    }
}
