/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


// Contains request info
import com.arsdigita.bebop.PageState;

import com.arsdigita.bebop.Form;

// For the form id

// The class we are extending
import com.arsdigita.bebop.MetaForm;

// The form to preview
import com.arsdigita.formbuilder.SimpleQuestionnaire;

// ACS 5 uses Log4J for logging
import org.apache.log4j.Logger;


/**
 * A dynamic form that displays what a form built with the Form
 * Builder service will look like.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/PreviewForm.java#10 $
 */
public class PreviewForm extends MetaForm {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/PreviewForm.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(PreviewForm.class.getName());

    private boolean m_inAdminMode = false;

    private PreviewFormPageConnector m_pageConnector;

    public PreviewForm(boolean inAdminMode, PreviewFormPageConnector pageConnector) {
        super("PreviewForm");

        m_inAdminMode = inAdminMode;

        m_pageConnector = pageConnector;
    }

    public Form buildForm(PageState pageState) {

        SimpleQuestionnaire questionnaire =
            m_pageConnector.getQuestionnaire(pageState);

        // We want admin links on the questionnaire
        questionnaire.setAdminEnabled(m_inAdminMode);

        Form form = (Form)questionnaire.createComponent();

        form.add(new FormIDHidden());

        return form;
    }
}
