/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 

import com.arsdigita.bebop.FormSection;
import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.CompoundComponent;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.formbuilder.PersistentHidden;
import com.arsdigita.formbuilder.PersistentLabel;
import com.arsdigita.formbuilder.PersistentText;
import com.arsdigita.bebop.BaseLink;


/**
 * This is an extension of the BaseAddObserver which
 * handles the editing of controls on a form by
 * adding additional links on each row.
 */
public abstract class BaseEditAddObserver extends BaseAddObserver {

    public void beforeAddingComponent(FormSection formSection,
                                      PersistentComponentFactory componentFactory,
                                      int componentPosition) {
        super.beforeAddingComponent(formSection,
                                    componentFactory,
                                    componentPosition);

        // Propagate the 3 column layout to form sections
        /*
          try {
          CompoundComponent fs = (CompoundComponent)componentFactory;
          fs.setContainer(new ColumnPanel(3, true));
          } catch (ClassCastException ex) {
          // Nada
          }
        */
    }

    public void addingComponent(PersistentComponentFactory componentFactory,
                                int componentPosition,
                                Component component) {
        super.addingComponent(componentFactory,
                              componentPosition,
                              component);
    }

    public void afterAddingComponent(FormSection formSection,
                                     PersistentComponentFactory componentFactory,
                                     int componentPosition) {
        super.afterAddingComponent(formSection,
                                   componentFactory,
                                   componentPosition);
        if (componentFactory instanceof PersistentHidden) {
            PersistentHidden hidden = (PersistentHidden)componentFactory;
            formSection.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.hidden_field")));
            formSection.add(new Label(hidden.getParameterName()));
        } 

        if(!(componentFactory instanceof PersistentLabel)) {
            BoxPanel b = new BoxPanel(BoxPanel.HORIZONTAL);

            if (!(componentFactory instanceof CompoundComponent)) {
                BaseLink edit = createLink("edit", componentFactory);
                b.add(edit);
            }

            BaseLink move = createLink("move", componentFactory);
            b.add(move);

            BaseLink delete = createLink("delete", componentFactory);
            delete.setConfirmation("Are you sure you wish to delete this widget?");
            b.add(delete);

            if (componentFactory instanceof CompoundComponent) {
                formSection.add(new Label(""));
                formSection.add(new Label(""));
            }
            formSection.add(b);
        }
    }

    /**
     * This method is use to create a link for editing
     * a component.
     */
    protected abstract BaseLink createLink(String label,
                                           PersistentComponentFactory component);
}
