/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.parameters;


// We create instances of this listener
import com.arsdigita.bebop.event.ParameterListener;

// The class that we are persisting
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;

// Thrown if the underlying DataObject with given id cannot be found
import com.arsdigita.domain.DataObjectNotFoundException;

// For the id of the persistent parameter listener
import java.math.BigDecimal;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;

import org.apache.log4j.Logger;


/**
 * Validates that a string has a particular minimum and maximum
 * length.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/parameters/PersistentStringInRangeValidationListener.java#10 $
 *
 */
public abstract class PersistentStringInRangeValidationListener
    extends PersistentParameterListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/parameters/PersistentStringInRangeValidationListener.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(PersistentStringInRangeValidationListener.class.getName());

    /**
     * The fully qualified name of the underlying DataObject of this class.
     */
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.Listener";

    /**
     * Constructor for creating a new listener that can be persisted
     */
    public PersistentStringInRangeValidationListener(int minLength, int maxLength) {

        super(PersistentStringInRangeValidationListener.class.getName());

        set("defaultDomainClass", this.getClass().getName());

        setMinLength(minLength);
        setMaxLength(maxLength);
    }

    /**
     * Constructor for retrieving a persistent parameter listener
     * from the database
     */
    public PersistentStringInRangeValidationListener(BigDecimal id)
        throws DataObjectNotFoundException {

        super(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public PersistentStringInRangeValidationListener(DataObject obj) {
        super(obj);
    }

    /**
     * Factory method that creates the Bebop component whose
     * persistence is handled by this domain object.
     */
    public ParameterListener createListener() {

        return new StringInRangeValidationListener(getMinLength(),
                                                   getMaxLength());
    }

    // *** Attribute Methods

    public void setMinLength(int minLength) {
        setListenerAttribute("minLength", Integer.toString(minLength));
    }

    public int getMinLength() {
        return Integer.parseInt(getListenerAttribute("minLength"));
    }

    public void setMaxLength(int maxLength) {
        setListenerAttribute("maxLength", Integer.toString(maxLength));
    }

    public int getMaxLength() {
        return Integer.parseInt(getListenerAttribute("maxLength"));
    }
}
