/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


// The class that we are making persistent
import com.arsdigita.bebop.form.CheckboxGroup;

// All ACSObjects have a unique id
import java.math.BigDecimal;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;

// Every PersistentComponentFactory can create a Bebop Component
import com.arsdigita.bebop.Component;

// Thrown if the underlying DataObject with given id cannot be found
import com.arsdigita.domain.DataObjectNotFoundException;


/**
 * This class is responsible for persisting Bebop CheckboxGroups. The CheckboxGroup
 * is saved with the save() method. To resurrect the CheckboxGroup, use the constructor
 * taking the id of the saved CheckboxGroup and then invoke createComponent().
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentCheckboxGroup.java#9 $
 *
 */
public class PersistentCheckboxGroup extends PersistentOptionGroup {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentCheckboxGroup.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * BASE_DATA_OBJECT_TYPE represents the full name of the
     * underlying DataObject of this class.
     */
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.Widget";

    // *** Constructors -------------

    /**
     * Constructor that creates a new CheckboxGroup domain object that
     * can be saved to the database later on.
     */
    public PersistentCheckboxGroup() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    /**
     * Constructor that creates a new CheckboxGroup domain object that
     * can be saved to the database later on.
     */
    public PersistentCheckboxGroup(String typeName) {
        super(typeName);
    }

    public PersistentCheckboxGroup(ObjectType type) {
        super(type);
    }

    public PersistentCheckboxGroup(DataObject obj) {
        super(obj);
    }

    /**
     * Constructor that retrieves an existing CheckboxGroup domain object
     * from the database.
     *
     * @param id The object id of the CheckboxGroup domain object to retrieve
     */
    public PersistentCheckboxGroup(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    /**
     * Extending classes can use this constructor to set the sub class
     * id and object type.
     */
    public PersistentCheckboxGroup(OID oID)
        throws DataObjectNotFoundException {

        super(oID);
    }

    public static PersistentCheckboxGroup create(String parameterName) {
        PersistentCheckboxGroup c = new PersistentCheckboxGroup();
        c.setup(parameterName);
        return c;
    }

    public boolean isMultiple() {
        return true;
    }

    /**
     * Create the CheckboxGroup whose persistence is managed
     * by this domain object.
     */
    public Component createComponent() {

        CheckboxGroup checkBox = new CheckboxGroup(getParameterName());

        addDataToComponent(checkBox);
        copyValuesToWidget(checkBox);
	checkBox.setClassAttr("vertical");
        return checkBox;
    }

}
