/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;

import com.arsdigita.formbuilder.PersistentHidden;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;




public class HiddenIDGenerator extends PersistentHidden {
    public static final String BASE_DATA_OBJECT_TYPE =
        PersistentHidden.BASE_DATA_OBJECT_TYPE;

    public HiddenIDGenerator() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public HiddenIDGenerator(String typeName) {
        super(typeName);

        setDefaultValue("::system.uniqueid::");
    }

    public HiddenIDGenerator(ObjectType type) {
        super(type);

        setDefaultValue("::system.uniqueid::");
    }

    public HiddenIDGenerator(DataObject obj) {
        super(obj);
    }

    public HiddenIDGenerator(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    public HiddenIDGenerator(OID oid)
        throws DataObjectNotFoundException {

        super(oid);
    }
}
