/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


// This BebopMapDispatcher lets us map Bebop pages to URLs
// in a convenient way
import com.arsdigita.bebop.BebopMapDispatcher;


// All admin UI pages extend this class

// The Pages of the admin UI
import com.arsdigita.formbuilder.ui.IndexPage;
import com.arsdigita.formbuilder.ui.FormPropertiesPage;
import com.arsdigita.formbuilder.ui.FormBuildingPage;
import com.arsdigita.formbuilder.ui.FormViewPage;
import com.arsdigita.formbuilder.ui.OptionGroupPage;

// We shouldn't need those here, but BebopMapDispatcher has
// no addPage method

import org.apache.log4j.Logger;



/**
 * The dispatcher of the Form Builder admin UI. All admin UI classes
 * are in the <code>com.arsdigita.formbuilder.ui</code> package. There are
 * a handful of pages that are each mapped to one relative URL and each
 * page is implemented by its own class (a subclass of Bebop Page).
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/FormBuilderDispatcher.java#9 $
 */
public class FormBuilderDispatcher extends BebopMapDispatcher {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/FormBuilderDispatcher.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(FormBuilderDispatcher.class);

    private static final String URL_ENDING = ".acs";

    /**
     * Constructor. Builds all pages and maps them to urls.
     */
    public FormBuilderDispatcher() {
        super();

        buildAndMapPages();
    }

    /**
     * Will populate the url-page map.
     */
    private void buildAndMapPages() {

        // Setup up the map between Pages and relative URLs
        addPage(IndexPage.instance().getRelativeURL(), IndexPage.instance());
        addPage("", IndexPage.instance());
        addPage(FormPropertiesPage.instance().getRelativeURL(), FormPropertiesPage.instance());
        addPage(FormBuildingPage.instance().getRelativeURL(), FormBuildingPage.instance());
        addPage(FormViewPage.instance().getRelativeURL(), FormViewPage.instance());
        addPage(OptionGroupPage.instance().getRelativeURL(), OptionGroupPage.instance());
    }

    public static String getURLEnding() {
        return URL_ENDING;
    }
}
