/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


import com.arsdigita.bebop.event.ParameterListener;

import com.arsdigita.util.UncheckedWrapperException;

import java.util.List;


/**
 * This class contains the attribute data type that are used for form
 * generation by the Form Builder.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/AttributeType.java#9 $
 *
 */
public class AttributeType {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/AttributeType.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Class m_parameterModelClass;

    private List m_validationListeners;

    public AttributeType(Class parameterModelClass) {

        m_parameterModelClass = parameterModelClass;

        m_validationListeners = new java.util.ArrayList();
    }

    /**
     * Standard attribute types
     */
    public static AttributeType INTEGER;
    public static AttributeType TEXT;
    public static AttributeType DATE;

    // The classes of the standard data types
    private static Class s_integerClass;
    private static Class s_textClass;
    private static Class s_dateClass;

    // Initialization of the standard attribute types
    static {

        try {

            s_integerClass = Class.forName("com.arsdigita.bebop.parameters.IntegerParameter");
            s_textClass = Class.forName("com.arsdigita.bebop.parameters.StringParameter");
            s_dateClass = Class.forName("com.arsdigita.bebop.parameters.DateParameter");

        } catch (ClassNotFoundException e) {
            throw new UncheckedWrapperException(e);
        }

        INTEGER = new AttributeType(s_integerClass);
        TEXT = new AttributeType(s_textClass);
        DATE = new AttributeType(s_dateClass);
    }

    //*** Attribute Methods

    public Class getParameterModelClass() {
        return m_parameterModelClass;
    }

    /**
     * Note that a not null validation listener needs not be added here. If the
     * attribute is required a NotEmptyValidationListener will be added to
     * to the widget.
     */
    public void addValidationListener(ParameterListener validationListener) {
        m_validationListeners.add(validationListener);
    }

    public List getValidationListeners() {
        return m_validationListeners;
    }
}
