/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


/**
 * Used to represent all attribute metadata of an
 * AttributeMetaDataProvider. Note this list will not function reliably
 * if it is shared by multiple threads. The way the Form Builder service
 * currently functions this never happens though.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/AttributeMetaDataList.java#7 $
 *
 */
public class AttributeMetaDataList {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/AttributeMetaDataList.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private java.util.ArrayList m_attributeList;
    private int m_iteratorIndex = 0;

    public AttributeMetaDataList() {

        m_attributeList = new java.util.ArrayList();

    }

    public void add(AttributeMetaData attributeMetaData) {

        m_attributeList.add(attributeMetaData);
    }

    public boolean hasNext() {

        return m_attributeList.size() > m_iteratorIndex;
    }

    public AttributeMetaData next() {

        return (AttributeMetaData)m_attributeList.get(m_iteratorIndex++);
    }

    public void setIteratorAtStart() {

        m_iteratorIndex = 0;
    }

    /**
     * Retrieve the first AttributeMetaData object in the collection with
     * the given parameter name (the parameter name should be unique). Returns
     * null if there is no such parameter name.
     */
    public AttributeMetaData getByParameterName(String parameterName) {

        // Loop over the attributes and return the first attribute with
        // matching parameter name
        this.setIteratorAtStart();
        while (this.hasNext()) {
            AttributeMetaData attribute = this.next();

            if (attribute.getParameterName().equals(parameterName)) {
                return attribute;
            }
        }

        // No matching parameter name found
        return null;
    }

    public int size() {
        return m_attributeList.size();
    }
}
