/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;

/**
 * Exposes all methods in {@link DomainService}.
 *
 * @author Stanislav Freidin
 * @author Gavin Doughtie
 * @version $Id: //core-platform/dev/src/com/arsdigita/domain/DomainServiceInterfaceExposer.java#13 $
 */

public class DomainServiceInterfaceExposer extends DomainService {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/DomainServiceInterfaceExposer.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     *
     * Get a property of the specified domain object.
     *
     * @see DomainObject#get(String)
     **/
    public static Object get(DomainObject domainObject, String attr) {
        return DomainService.get(domainObject, attr);
    }

    /**
     * Get the underlying {@link DataObject} of the {@link DomainObject}
     **/
    public static DataObject getDataObject(DomainObject domainObject) {
        return DomainService.getDataObject(domainObject);
    }

    /**
     *
     * Get the data collection encapsulated by a domain collection.
     *
     * @see DomainObject#get(String)
     **/
    public static DataCollection
        getDataCollection (DomainCollection domainCollection)
    {
        return DomainService.getDataCollection(domainCollection);
    }

    // These methods modify domain objects and should be used cautiously.

    /**
     *
     * Set a property of the DomainObjects DataObject.
     *
     * @see DomainObject#set(String, Object)
     **/
    public static void set(DomainObject domainObject, String attr, Object value) {
        DomainService.set(domainObject, attr, value);
    }

    /**
     *
     * Set an association DomainObjects DataObject.
     *
     * @see DomainObject#set(String, Object)
     **/
    public static void setAssociation(DomainObject domainObject,
                                      String attr, DomainObject dobj) {
        DomainService.setAssociation(domainObject, attr, dobj);
    }

    /**
     *
     * Adds data object specified by <i>value</i> to the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#add(String, DataObject)
     */
    public static DataObject add(DomainObject domainObject,
                           String roleName, DataObject value) {
        return DomainService.add(domainObject, roleName, value);
    }

    /**
     *
     * Adds domain object specified by <i>value</i> to the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#add(String, DomainObject)
     */
    public static DataObject add(DomainObject domainObject,
                           String roleName, DomainObject value) {
        return DomainService.add(domainObject, roleName, value);
    }

    /**
     *
     * Removes data object specified by <i>value</i> from the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#remove(String, DataObject)
     */
    public static void remove(DomainObject domainObject,
                              String roleName, DataObject value) {
        DomainService.remove(domainObject, roleName, value);
    }

    /**
     *
     * Removes domain object specified by <i>value</i> from the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#remove(String, DomainObject)
     */
    public static void remove(DomainObject domainObject,
                              String roleName, DomainObject value) {
        DomainService.remove(domainObject, roleName, value);
    }

    /**
     *
     * Clears specified role (with multiplicity > 1) of specified
     * domain object.
     *
     * @see DomainObject#clear(String)
     */
    public static void clear(DomainObject domainObject, String roleName) {
        DomainService.clear(domainObject, roleName);
    }

}
