/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataCollection;

/**
 *
 * This class should be extended by domain object services that
 * need privileged access to the DataObject encapsulated by a
 * DomainObject or the DataCollection encapsulated by a DomainCollection.
 *
 * @author Oumi Mehrotra
 * @version 1.0
 *
 * @see com.arsdigita.persistence.DataObject
 **/
public abstract class DomainService {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/DomainService.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     *
     * Get a property of the specified domain object.
     *
     * @see DomainObject#get(String)
     **/
    protected static Object get(DomainObject domainObject, String attr) {
        return domainObject.get(attr);
    }

    /**
     * Get the underlying {@link DataObject} of the {@link DomainObject}
     **/
    protected static DataObject getDataObject(DomainObject domainObject) {
        return domainObject.getDataObject();
    }

    /**
     *
     * Get the data collection encapsulated by a domain collection.
     *
     * @see DomainObject#get(String)
     **/
    protected static DataCollection
        getDataCollection (DomainCollection domainCollection)
    {
        return domainCollection.m_dataCollection;
    }

    // These methods modify domain objects and should be used cautiously.

    /**
     *
     * Set a property of the DomainObjects DataObject.
     *
     * @see DomainObject#set(String, Object)
     **/
    protected static void set(DomainObject domainObject, String attr, Object value) {
        domainObject.set(attr, value);
    }

    /**
     *
     * Set an association DomainObjects DataObject.
     *
     * @see DomainObject#set(String, Object)
     **/
    protected static void setAssociation(DomainObject domainObject,
                                         String attr, DomainObject dobj) {
        domainObject.set(attr, dobj);
    }

    /**
     * Adds data object specified by <i>value</i> to the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#add(String, DataObject)
     */
    protected static DataObject add(DomainObject domainObject,
                                    String roleName, DataObject value) {
        return domainObject.add(roleName, value);
    }

    /**
     * Adds domain object specified by <i>value</i> to the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#add(String, DomainObject)
     */
    protected static DataObject add(DomainObject domainObject,
                                    String roleName, DomainObject value) {
        return domainObject.add(roleName, value);
    }

    /**
     *
     * Removes data object specified by <i>value</i> from the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#remove(String, DataObject)
     */
    protected static void remove(DomainObject domainObject,
                                 String roleName, DataObject value) {
        domainObject.remove(roleName, value);
    }

    /**
     *
     * Removes domain object specified by <i>value</i> from the
     * specified role (with multiplicity>1) of the specified domain object.
     *
     * @see DomainObject#remove(String, DomainObject)
     */
    protected static void remove(DomainObject domainObject,
                                 String roleName, DomainObject value) {
        domainObject.remove(roleName, value);
    }

    /**
     *
     * Clears specified role (with multiplicity > 1) of specified
     * domain object.
     *
     * @see DomainObject#clear(String)
     */
    protected static void clear(DomainObject domainObject, String roleName) {
        domainObject.clear(roleName);
    }

}
