/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import com.arsdigita.persistence.metadata.Property;

/**
 * <p>This interface is used to control traversal of domain
 * objects. Whenever a property is encountered, the {@link
 * #processProperty} method will be called to determine whether or not
 * to continue processing the object.  The most important use for this
 * is to prevent the needless (and potentially infinite) traversal of
 * associations between objects, but it can also be used to filter out
 * certain attributes.</p>
 *
 * <p>Instances of this class need to be registered using the
 * DomainObjectTraversal.registerAdapter method.</p>
 *
 * @see com.arsdigita.domain.DomainObjectTraversal
 * @see com.arsdigita.domain.SimpleDomainObjectTraversalAdapter
 * @version $Id: //core-platform/dev/src/com/arsdigita/domain/DomainObjectTraversalAdapter.java#5 $
 */
public interface DomainObjectTraversalAdapter {
    /**
     * Invoked to determine whether to process a property.
     * Should return true to allow processing to commence,
     * false to prevent it.
     *
     * @param obj the domain object currently being processed
     * @param path the path to the current domain object from
     * the root object being traversed
     * @param prop the property about to be processed
     * @param context the context in which the object is traversed
     * @return true if the property should be processed
     */
    public boolean processProperty(DomainObject obj,
                                   String path,
                                   Property prop,
                                   String context);
}
