/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import java.util.EventListener;

/**
 * Used to register callbacks for the code to run
 * when a request starts or ends.
 *
 * @author Bill Schneider 
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 * @since 4.5 */
public interface RequestListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/RequestListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Called when ACSServlet starts processing an incoming request.
     * @param e the event
     */
    public void requestStarted(RequestEvent e);

    /**
     * Called when ACSServlet finishes processing an incoming request.
     * @param e the event
     */
    public void requestFinished(RequestEvent e);
}
