/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Request event class.  Passed as a
 * parameter to the methods of RequestListener.
 *
 * @see RequestListener
 * @author Bill Schneider
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 * @since 4.5 */
public class RequestEvent  {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/RequestEvent.java#9 $";

    private HttpServletRequest m_req;
    private HttpServletResponse m_resp;
    private RequestContext m_ctx;
    private boolean m_start;
    private boolean m_finished_normal;

    /**
     * Creates a new <code>RequestEvent</code> with a success/failure status
     * code.
     * @param req the current request
     * @param resp the current response
     * @param ctx the current request context
     * @param start if true, indicates that this is a start-request event;
     * if false, this is an end-request event.
     * @param finishedNormal if true, indicates the request finished
     * without error.
     */
    public RequestEvent(HttpServletRequest req,
                        HttpServletResponse resp,
                        RequestContext ctx,
                        boolean start,
                        boolean finishedNormal) {
        m_req = req;
        m_resp = resp;
        m_ctx = ctx;
        m_start = start;
        m_finished_normal = finishedNormal;
    }


    /**
     * Creates a new <code>RequestEvent</code> with no status code.
     * @param req the current request
     * @param resp the current response
     * @param ctx the current request context
     * @param start if true, indicates that this is a start-request event;
     * if false, this is an end-request event.
     */
    public RequestEvent(HttpServletRequest req,
                        HttpServletResponse resp,
                        RequestContext ctx,
                        boolean start) {
        this(req, resp, ctx, start, false);
    }


    /**
     * Returns the current request for the request event.
     * @return the current request
     */
    public HttpServletRequest getRequest() {
        return m_req;
    }

    /**
     * Returns the current response for the request event.
     * @return the current response
     */
    public HttpServletResponse getResponse() {
        return m_resp;
    }

    /**
     * Returns the current request context for the request event.
     * @return the current request context
     */
    public RequestContext getRequestContext() {
        return m_ctx;
    }

    /**
     * Returns true if the event is a start-request event;
     * false for an end-request event.
     *
     * @return  true if we're starting a request, false at end.
     */
    public boolean isStart() {
        return m_start;
    }

    /**
     * Returns a status code to indicate whether the request
     * finished without error.
     *
     * @return true if the request finished without exception.
     * false if the request finished with an error, or if the request
     * event is a start-request.
     */
    public boolean finishedNormal() {
        return m_finished_normal;
    }
}
