/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OrionDefaultServlet extends HttpServlet
    implements DispatcherConstants {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/OrionDefaultServlet.java#8 $ by $Author: dennis $ $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(OrionDefaultServlet.class);

    public void service(HttpServletRequest req, HttpServletResponse resp)
        throws ServletException {

        ServletContext ctx = getServletContext();
        RequestDispatcher rd = ctx.getNamedDispatcher("orion.filehandler");

        try {
            rd.include(req, resp);
        } catch (Exception e) {
            s_log.error("caught error", e);
            throw new ServletException(e.getMessage());
        }
    }
}
