/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

import com.arsdigita.initializer.Script;
import com.arsdigita.util.ResourceManager;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;

/**
 * Bootstraps the ACS by
 * calling the initializers in the enterprise.init file.
 *
 * @author Raphael Schloming (rhs@mit.edu)
 * @version $Revision: #14 $ $Date: 2004/04/07 $ */

public class InitializerServlet extends HttpServlet {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/InitializerServlet.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Script m_ini = null;
    private static boolean loaded = false;

    /**
     * Starts up the web environment for the ACS by loading the specified
     * initializer script.
     **/
    public void init() throws ServletException {
        if (loaded) {
            System.err.println("Fatal error: Initializer executing multiple " +
                               "times.  Aborting.");
            return;
        } else {
            loaded = true;
        }
        ServletConfig conf = getServletConfig();
        String scriptName = conf.getInitParameter("init");
        //ClassLoader cl = getClass().getClassLoader();
        //InputStream is = cl.getResourceAsStream(scriptName);
        //URL url = cl.getResource(scriptName);

        ResourceManager rm =
            com.arsdigita.util.ResourceManager.getInstance();
        rm.setServletContext(getServletContext());
        InputStream is = rm.getResourceAsStream(scriptName);

        System.out.println("Initialization using: " + scriptName);

        if (is == null) {
            throw new ServletException("Couldn't find " + scriptName);
        }

        try {
            m_ini = new Script(is);
            m_ini.startup();
        } catch (Throwable e) {
            // We positively want to know about any error during
            // initialization, including things like NoClassDefFoundError
            // etc.
            System.err.println("Initialization failed with error " +
                               e.getMessage() + ".");
            e.printStackTrace();
            System.err.println("ERROR: INITIALIZATION FAILED. "+
                               "ACS SYSTEM NOT USEABLE.  PLEASE CORRECT " +
                               "ERRORS ABOVE.");
            throw new UnavailableException(e + "\n" + e.getMessage());
        }

        System.out.println("Initialization finished");
    }

    public void destroy() {
        m_ini.shutdown();
    }
}
