/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.dispatcher;

/**
 * When thrown, this throwable will percolate up the call stack to
 * the top level to abort all processing of this request.  The top
 * level (BaseDispatcherServlet) will treat it as a normal request
 * and try to commit the transaction
 */

public class AbortRequestSignal extends Error {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/dispatcher/AbortRequestSignal.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // extending error is a bit of a misnomer but it's what
    // we want: an unchecked exception that won't get caught
    // by catch (Exception).
}
