/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.developersupport;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * You can use this class for capturing and logging timestamped stack traces.
 * In addition to the actual stack trace, instances of this class "remember" the
 * name of the thread in which they were instantiated.
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2003-12-22
 * @version $Id: //core-platform/dev/src/com/arsdigita/developersupport/StackTrace.java#3 $
 **/
public final class StackTrace extends Throwable {
    private final static DateFormat FORMATTER =
        new SimpleDateFormat("HH:mm:ss.S");

    private final String m_thread = Thread.currentThread().getName();
    private final long m_time = System.currentTimeMillis();

    /**
     * Returns both the {@link #getThreadName() thread name} and the {@link
     * #getTimestamp() timestamp}.
     **/
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("[thread=").append(getThreadName());
        sb.append("; timestamp=");
        sb.append(FORMATTER.format(getTimestamp())).append("]");
        return sb.toString();
    }

    public String getThreadName() {
        return m_thread;
    }

    public Date getTimestamp() {
        return new Date(m_time);
    }
}
