/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.developersupport;

/**
 * A light-weight alternative to java.lang.Integer.
 *
 * <p>Note that equality is currently equivalent to identity.</p>
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2004-02-10
 * @version $DateTime: 2004/04/07 16:07:11 $ $Revision: #3 $
 **/
final class MutableInteger {
    private int m_counter;

    /**
     * Initializes to 0.
     **/
    public MutableInteger() {}

    public void increment() {
        m_counter++;
    }

    public int intValue() {
        return m_counter;
    }

    public String toString() {
        return String.valueOf(m_counter);
    }
}
