/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.core;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.security.KeyStorage;
import com.arsdigita.persistence.DedicatedConnectionSource;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.Startup;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/core/TroikaRickshawUpgrade2.java#7 $
 */
public class TroikaRickshawUpgrade2 {
    private static final Logger s_log = Logger.getLogger
        (TroikaRickshawUpgrade2.class);

    public static final void main(final String[] args) throws IOException {
        final Session session = makeSession
            (RuntimeConfig.getConfig().getJDBCURL());

        final TransactionContext tc = session.getTransactionContext();
        tc.beginTxn();

        final ObjectType type = session.getMetadataRoot().getObjectType
            ("com.arsdigita.runtime.Initializer");
        session.create(new OID(type, "com.arsdigita.core.Initializer"));
        session.flushAll();

        tc.commitTxn();

        final Startup startup = new Startup();

        // This awkward hack exists to handle the case where the
        // ccm-core being upgraded contains UDCTs that reference CMS
        // content types.
//         try {
//             final Class clacc = Class.forName("com.arsdigita.cms.Initializer");
//             startup.add((com.arsdigita.runtime.Initializer)
//                             Classes.newInstance(clacc));
//         } catch (ClassNotFoundException cnfe) {
//             // The normal scenario; carry on
//         }

        startup.run();

        final TransactionContext tcontext = SessionManager.getSession
            ().getTransactionContext();

        tcontext.beginTxn();

        KeyStorage.KERNEL_KEY_STORE.init();
        loadWebDev();

        tcontext.commitTxn();
    }

    private static Session makeSession(final String jdbc) {
        final String pdl = "/com/arsdigita/runtime/Initializer.pdl";
        final MetadataRoot root = new MetadataRoot();
        final PDLCompiler compiler = new PDLCompiler();

        compiler.parse
            (new InputStreamReader
             (TroikaRickshawUpgrade2.class.getResourceAsStream(pdl)), pdl);
        compiler.emit(root);

        final DedicatedConnectionSource source =
            new DedicatedConnectionSource(jdbc);

        return SessionManager.open("upgrade", root, source);
    }

    private static void loadWebDev() {
        PackageType packType;
        try {
            packType = PackageType.findByKey("webdev-support");
        } catch (DataObjectNotFoundException e) {
            // Add the package type to the database
            packType = PackageType.create
                ("webdev-support", "WebDeveloper Support", "WebDeveloper Supports",
                 "http://arsdigita.com/webdev-support");
        }
        SiteNode node;
        try {
            node = SiteNode.getSiteNode("ds");
        } catch (DataObjectNotFoundException e) {
            // Add the node and the package instance on that node.
            node = SiteNode.createSiteNode("ds");
            // Specify the URL stub for this package instance.
            node.mountPackage(packType.createInstance("webdev-support"));
            // Map the package type to a dispatcher class
            packType.setDispatcherClass("com.arsdigita.webdevsupport.Dispatcher");
        }
    }
}
