/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.core;

import com.arsdigita.runtime.*;

/**
 * LibCheck
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 **/

public class LibCheck extends BaseCheck {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/core/LibCheck.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private boolean checkJAAS() {
        final String classname = "javax.security.auth.Policy";

        if (isClassFound(classname)) {
            m_out.println(message("jaas_found"));

            checkDuplicates(classname);
            return true;
        } else {
            m_out.println(message("jaas_not_found"));
            m_out.println();
            m_out.println(message("security_jars"));
            m_out.println();
            m_out.println(message("classpath"));
            return false;
        }
    }

    private boolean checkJCE() {
        final String classname = "javax.crypto.Cipher";

        if (isClassFound(classname)) {
            m_out.println(message("jce_found"));

            checkDuplicates(classname);
            return true;
        } else {
            m_out.println(message("jce_not_found"));
            m_out.println();
            m_out.println(message("security_jars"));
            m_out.println();
            m_out.println(message("classpath"));
            return false;
        }
    }

    public void run(ScriptContext ctx) {
        if (checkJAAS() && checkJCE()) {
            status(PASS);
        } else {
            status(FAIL);
        }
    }

}
