/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.core;

import com.arsdigita.db.DbHelper;
import com.arsdigita.packaging.*;
import com.arsdigita.runtime.*;
import com.arsdigita.util.*;
import com.arsdigita.util.jdbc.*;

import java.sql.*;

/**
 * DBCheck
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

public class DBCheck extends BaseCheck {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/core/DBCheck.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private boolean checkOracleJDBC() {
        final String classname = "oracle.jdbc.driver.OracleDriver";

        if (isClassFound(classname)) {
            m_out.println(message("oracle_jdbc_found"));

            checkDuplicates(classname);
            return true;
        } else {
            m_out.println(message("oracle_jdbc_not_found"));
            m_out.println();
            m_out.println(message("classpath"));
            return false;
        }
    }

    private boolean checkDatabaseConnection() {
        if (m_verbose) {
            m_out.println("Checking that RuntimeConfig is configured");
        }

        ConfigRegistry reg = new ConfigRegistry();
        if (reg.isConfigured(RuntimeConfig.class)) {
            m_out.println(message("runtime_configured"));
        } else {
            m_out.println(message("runtime_unconfigured"));
            return false;
        }

        if (m_verbose) {
            m_out.println("Checking that JDBC URL is set");
        }

        final String url = RuntimeConfig.getConfig().getJDBCURL();
        if (url == null) {
            m_out.println(message("jdbc_unset"));
            return false;
        } else {
            m_out.println(message("jdbc_set"));
        }
        Connection conn = null;
        String error = null;

        if (m_verbose) {
            m_out.println("Connecting to JDBC URL " + url);
        }

        try {
            conn = Connections.acquire(url);
        } catch (Exception e) {
            error = e.getMessage();
        }

        if (conn == null) {
            if (m_verbose) {
                m_out.println("Cannot connect");
            }

            m_out.println(message("db_down"));

            m_out.println("ERROR: " + error);
            return false;
        } else {
            if (m_verbose) {
                m_out.println("Connection succesful");
            }

            m_out.println(message("db_up"));
            return true;
        }
    }

    private boolean checkSupportedDatabase(int db) {
        if ( db == DbHelper.DB_DEFAULT ) {
            m_out.println(message("unsupported_database"));
            if (m_verbose) {
                m_out.println(RuntimeConfig.getConfig().getJDBCURL());
            }
            return false;
        }
        m_out.println(message("supported_database"));
        return true;
    }

    public void run(ScriptContext ctx) {
        int db = DbHelper.getDatabaseFromURL(RuntimeConfig.
                                             getConfig().getJDBCURL());

        if ( ! checkSupportedDatabase(db) ) {
            status(FAIL);
        } else {
            if ( db == DbHelper.DB_POSTGRES ) {
                if ( checkDatabaseConnection() ) {
                    status(PASS);
                } else {
                    status(FAIL);
                }
            } else {
                if (checkOracleJDBC() && checkDatabaseConnection()) {
                    status(PASS);
                } else {
                    status(FAIL);
                }
            }
        }
    }

}
