/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;



import java.math.BigDecimal;
import com.arsdigita.bebop.tree.TreeNode;


/**
 *
 * <p>A light-weight category node. See {@link
 * com.arsdigita.categorization.CategoryTreeModelLite}. </p>
 *
 * @see com.arsdigita.categorization.CategoryTreeModelLite
 * @author Daniel Berrange
 * @version $Revision: #10 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class CategoryTreeNodeLite implements TreeNode  {
    private BigDecimal m_id;
    private String m_name;
    private boolean m_hasChild;

    public CategoryTreeNodeLite(BigDecimal id,
                                String name,
                                boolean hasChild) {
        m_id = id;
        m_name = name;
        m_hasChild = hasChild;
    }

    public Object getKey() {
        return m_id.toString();
    }

    public Object getElement() {
        return m_name;
    }

    public BigDecimal getID() {
        return m_id;
    }

    public boolean hasChildren() {
        return m_hasChild;
    }
}
