/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;

import com.arsdigita.util.UncheckedWrapperException;

/**
 * Category exception.  Note that this is unchecked exception.
 *
 * @author Michael Pih
 * @version $Revision: #9 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class CategorizationException extends UncheckedWrapperException {

    public CategorizationException(String message) {
        super(message);
    }

    /**
     * @deprecated use {@link #CategorizationException(Throwable)}.
     **/
    public CategorizationException(Exception ex) {
        super(ex);
    }

    public CategorizationException(Throwable throwable) {
        super(throwable);
    }

    public CategorizationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }
}
