/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.util;

/**
 * A map that keeps its entries in a fixed sequence. All iterators returned
 * by this class, for example by <code>entrySet().iterator()</code>, are
 * guaranteed to return the entries in the order in which they were put in
 * the map. This implementation allows <code>null</code> for both the key
 * or the associated value for a map entry.
 *
 * <p>
 * Almost all of the map operations, for example {@link #get get} or {@link
 * #containsKey containsKey} require time linear in the size of the map,
 * making this map only suitable for small map sizes.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/util/SequentialMap.java#7 $
 */
public class SequentialMap extends com.arsdigita.util.SequentialMap {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/util/SequentialMap.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Creates an empty <code>SequentialMap</code>.
     */
    public SequentialMap() {
        super();
    }

    /**
     * Find an entry with the given key. <code>key</code> may be null.
     *
     * <p>
     * Requires time linear in the size of the map
     *
     * @param key the key to find
     * @return the index with key <code>key</key> or -1 if no such entry
     * exists.
     */
    public int findKey(Object key) {
        return indexOf(key);
    }
}
