/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.table;

import java.util.Iterator;

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.util.Lockable;

/**
 * Describe interface <code>TableColumnModel</code> here.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/table/TableColumnModel.java#7 $
 */
public interface TableColumnModel extends Lockable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/TableColumnModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    void add(TableColumn column);

    TableColumn get(int columnIndex);

    /**
     * Insert a column at the given index. The columns from
     * <code>columnIndex</code> on are shifted one up.
     *
     * @param columnIndex the index for the new column.
     * @param column the table column to add to the model.
     * @pre 0 <= columnIndex && columnIndex <= size()
     */
    void add(int columnIndex, TableColumn column);

    void set(int columnIndex, TableColumn v);

    int size();

    int getIndex(Object columnIdentifier);

    Iterator columns();

    void remove(TableColumn column);

    SingleSelectionModel getSelectionModel();

    void setSelectionModel(SingleSelectionModel model);
}
