/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.portal;

import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;

/**
 *  <p>An interface specifying {@link
 * com.arsdigita.bebop.Component}-like behavior for a PortletRenderer,
 * insofar as XML generation is concerned.  Since a PortletRenderer
 * gets its state only from {@link PortalModel}, it is stateless from
 * the Bebop point of view and does not need Component's state
 * management.  We do still, however, want PortletRenderer to produce
 * XML just as other Components do.</p>
 *
 * <p>The PortletRenderer interface is used in {@link Portal} when it
 * builds a new {@link PortalModel} and fetches a set of portlets.
 * Portal calls {@link #generateXML} on each PortletRenderer
 * returned.</p>
 *
 * <p>Note that implementers of PortletRenderers will ordinarily want
 * to extend {@link AbstractPortletRenderer} since it provides a
 * default XML frame for portlets, one that the Portal stylesheet
 * knows to transform.</p>
 *
 * @see Portal
 * @see PortalModel
 * @see PortalModelBuilder
 * @see AbstractPortletRenderer
 * @author Justin Ross
 * @author James Parsons
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/portal/PortletRenderer.java#8 $ */
public interface PortletRenderer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/portal/PortletRenderer.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Build an XML fragment and attach it to this component's parent.
     * Someone implementing a TimeOfDayPortlet could, for instance,
     * override this method to fetch the time and, say, wrap it in a
     * Bebop {@link com.arsdigita.bebop.Label}.  Note, however, that
     * it is preferable to extend {@link
     * com.arsdigita.bebop.AbstractPortlet} since it provides a
     * default "XML wrapper" for portlets.
     *
     * @param pageState the PageState of the current request.
     * @param parentElement the element to which to attach the XML this
     * method creates.
     * @pre pageState != null
     * @pre parentElement != null
     */
    void generateXML(PageState pageState, Element parentElement);

    boolean isDirty();

    Object getCacheKey();
}
