/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.globalization.Globalization;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

/**
 *    A class that represents the model for URL form parameters.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Rory Solomon 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/URLParameter.java#8 $
 */
public class URLParameter extends StringParameter {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/URLParameter.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public URLParameter(String name) {
        super(name);
    }

    public Object transformValue(HttpServletRequest request)
        throws IllegalArgumentException {

        String requestValue = Globalization.decodeParameter(request, getName());
        if (requestValue==null) {
            return null;
        }
        URL URLValue;
        try {
            URLValue = new URL(requestValue);
        } catch (MalformedURLException e) {
            try {
                URLValue = new URL("HTTP://" + requestValue);
            } catch (MalformedURLException e2) {
                throw new IllegalArgumentException
                    (getName() + " is not a valid URL: '" + requestValue +
                     "'; " + e2.getMessage());
            }
        }
        return unmarshal(requestValue);
    }

}
