/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 *     Verifies that the
 *    parameter's type is the expected type
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Stas Freidin 
 *    @author Rory Solomon  */
public class TypeCheckValidationListener extends GlobalizedParameterListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/TypeCheckValidationListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Class m_type;

    public TypeCheckValidationListener(Class type) {
        this.m_type = type;
    }

    public TypeCheckValidationListener(Class type, GlobalizedMessage error) {
        this.m_type = type;
        setError(error);
    }

    public void validate (ParameterEvent e) {

        ParameterData data = e.getParameterData();
        Object obj = data.getValue();

        if (obj == null && data.isTransformed()) {
            return;
        }

        if (getError() == null) {
            setError(new GlobalizedMessage(
                                           "type_check",
                                           getBundleBaseName(),
                                           new Object[] {
                                               data.getName(),
                                               m_type.getName(),
                                               obj.toString(),
                                               obj.getClass().getName()
                                           }
                                           ));
        }

        if (!m_type.isInstance(obj)) {
            data.addError(getError());
        }
    }
}
