/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.list;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.util.LockableImpl;

/**
 * An abstract class that implements ListModelBuilder by concretely
 * implementing the Lockable interface and leaving only the makeModel method
 * abstract. This allows for anonymous inner classes that implement the
 * ListModelBuilder interface without having to implement Lockable as well.
 *
 * @author Archit Shah 
 **/
public abstract class AbstractListModelBuilder
    extends LockableImpl implements ListModelBuilder {

    public abstract ListModel makeModel(List l, PageState state);
}
