/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

/**
 * JSP tag handler to show contents from a model-backed List.
 * <p>
 * Usage:
 * <pre>
 * &lt;show:list name="mylist"/>
 * </pre>
 * ... displays the list at this point in the JSP with global styling
 * for the list and its contents.  Or,
 *
 *  <pre>
 * &lt;show:list name="mylist">
 *    show list item here <show:listItem/>
 * &lt;/show:list>
 * </pre>
 *
 * ... has the effect of locally-styling the list contents in the JSP,
 * while globally styling the individual item inside the list.
 * <p>
 * Note that a Bebop List isn't really a Container, but from the JSP's
 * perspective of manipulating Bebop XML output, and not the components
 *  themselves, the behavior is container-like.
 */
public class ShowList extends ShowCellList {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/ShowList.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * set up the input context as our parent class would except
     * evaluate the body of the show:list tag only if the list in
     * question isn't empty.
     */
    protected TreeWalker makeTreeWalker() {
        TreeWalker tw = createTreeWalker(getInputContext(), new NodeFilter() {
                public short acceptNode(Node n) {
                    if (n.getNodeName().equals("bebop:cell")) {
                        return FILTER_ACCEPT;
                    }
                    return FILTER_SKIP;
                }
            });
        return tw;
    }
}
