/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.globalization.GlobalizedMessage;
import javax.servlet.jsp.JspException;

/**
 * Defines a Submit widget at the current location in the JSP page.
 * The "name" attribute is the name of the submit widget.  The text
 * displayed to the user is globalized.  The "label" attribute is used
 * as a key in the ResourceBundle in the currently-running
 * application, and the "bundle" attribute may be used to specify a
 * fully-qualified ResourceBundle name explicitly.  The "label"
 * attribute may instead be used to provide non-globalized label text.
 *
 * <p>
 * Example, globalized:
 * <pre>
 * &lt;define:submit name="mySubmit" label="msg.key"
 *       bundle="com.arsdigita.notes.NotesResources"/>
 * </pre>
 * Example, not globalized:
 * <pre>
 * &lt;define:submit name="mySubmit" label="Submit form now!"/>
 * </pre>
 *
 * @see com.arsdigita.bebop.form.Submit */
public class DefineSubmit extends DefineComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineSubmit.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Submit m_submit;
    private String m_label;
    private String m_bundleName;

    public int doStartTag() throws JspException {
        if (m_label == null) {
            m_label = getName();
        }
        GlobalizedMessage gm;
        if (m_bundleName == null) {
            gm = new GlobalizedMessage(m_label);
        } else {
            gm = new GlobalizedMessage(m_label, m_bundleName);
        }
        m_submit = new Submit(gm);
        // add form to parent
        return super.doStartTag();
    }

    protected final Component getComponent() {
        return m_submit;
    }

    public void setLabel(String s) {
        m_label = s;
    }

    public void setBundle(String s) {
        m_bundleName = s;
    }
}
