/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;





import com.arsdigita.bebop.parameters.ParameterModel;

/**
 *    A class representing a reset button in an HTML form.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Stas Freidin 
 *    @author Rory Solomon 
 *    @author Michael Pih 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/Reset.java#7 $
 */
public class Reset extends Widget {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/Reset.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public Reset(String name) {
        super(name);
    }

    public Reset (ParameterModel model) {
        super(model);
    }

    /**
     *      Returns a string naming the type of this widget.
     */
    protected String getType() {
        return "reset";
    }

    public boolean isCompound() {
        return false;
    }

}
