/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;



import java.util.Iterator;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ArrayParameter;
// This interface contains the XML element name of this class
// in a constant which is used when generating XML
import com.arsdigita.bebop.util.BebopConstants;

// The CheckboxGroup generates its own XML
import com.arsdigita.xml.Element;

/**
 *     A class
 *    representing a <em>group</em> of associated checkboxes.
 *
 *    @author Karl Goldstein
 *    @author Uday Mathur
 *    @author Rory Solomon
 *    @author Michael Pih
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/CheckboxGroup.java#8 $ */
public class CheckboxGroup extends OptionGroup implements BebopConstants {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/CheckboxGroup.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public CheckboxGroup(String name) {
        this(new ArrayParameter(name));
    }

    public CheckboxGroup(ArrayParameter param) {
        super(param);
        m_xmlElement = BEBOP_CHECKBOX;
    }

    /**
     *  Returns a string naming the type of this widget.
     */
    public String getType() {
        return "checkbox";
    }

    /** The XML tag.
     *  @return The tag to be used for the top level DOM element
     *  generated for this type of Widget.  */
    protected String getElementTag() {
        return BEBOP_CHECKBOXGROUP;
    }

    /**
     * <p>Generates DOM fragment:
     * <p><code><pre>
     * &lt;bebop:checkboxGroup>
     *  &lt;bebop:checkbox name=... label=... value=... [checked=...]/>
     *  ...
     * &lt;/bebop:checkboxGroup>
     * </pre></code>
     */
    public void generateWidget(PageState state, Element parent) {
        Element checkboxGroup = parent.newChildElement (getElementTag(), BEBOP_XML_NS);
        exportAttributes(checkboxGroup);

        for ( Iterator i = getOptions(state); i.hasNext(); ) {
            Option o = (Option)i.next();
            o.generateXML(state, checkboxGroup);
        }
    }

}
