/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import java.util.EventListener;

/**
 * Specifies the interface for handling events on {@link
 * com.arsdigita.bebop.Table}.  Programmers wishing to override just
 * one of these methods, not both, may prefer to use {@link
 * TableActionAdapter}.
 *
 * @see TableActionEvent
 * @see TableActionAdapter
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/TableActionListener.java#8 $
 */
public interface TableActionListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/TableActionListener.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * An event handler for actions on a particular cell or a set of
     * cells.
     *
     * @param e the event fired for the table.
     */
    void cellSelected(TableActionEvent e);

    /**
     * An event handler for actions on a particular column heading or
     * set of column headings.
     *
     * @param e the event fired for the table.
     */
    void headSelected(TableActionEvent e);
}
