/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.FormProcessException;
import java.util.EventListener;

/**
 *    Defines the interface for a class that implements a validation check
 *    on a set of form data.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormValidationListener.java#8 $
 */

public interface FormValidationListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormValidationListener.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Performs a validation check on the specified <tt>FormData</tt>
     * object, involving any number of parameters.
     *
     * <p>The check is always performed after all HTTP request
     * parameters have been converted to data objects and stored in the
     * FormData object.
     *
     * <p>If a validation error is encountered, the <tt>setError</tt>
     * method of the <tt>FormData</tt> object may be used to set an
     * error message for reporting back to the user.
     *
     * <p>This method is responsible for catching any exceptions that
     * may occur during the validation.  These exceptions may either
     * be handled internally, or if they are unrecoverable may be
     * rethrown as instances of <code>FormProcessException</code>.
     *
     * @param model The form model describing the structure and properties
     * of the form data included with this request.  The validation procedure
     * may require knowledge of form or parameter properties to complete.
     *
     * @param data The container for all data objects associated with
     * the request.  All parameters specified in the form model are
     * converted to data objects and stored in this container before
     * any form validation procedures are called.
     *
     * @param request The HTTP request information from which the form
     * data was extracted.  Note that the request object is supplied
     * only in case the validation procedure involves contextual
     * information (information extracted from cookies or the peer
     * address, for example).
     *
     * @exception FormProcessException If the data does not pass the
     * check. */

    void validate(FormSectionEvent e) throws FormProcessException;

}
