/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import java.util.EventListener;

import com.arsdigita.bebop.FormProcessException;

/**
 * The listener called just before a form starts examining a
 * submission. This listener can throw a {@link FormProcessException} to
 * indicate that any further processing of the submission should be
 * aborted. This usually leaves the corresponding {@link
 * com.arsdigita.bebop.FormData FormData} object in an undefined
 * state.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormSubmissionListener.java#7 $
 */
public interface FormSubmissionListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormSubmissionListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * This method gets called as soon as the <code>FormData</code> for a
     * form has been filled with the request parameters. The values in the
     * <code>FormData</code> are transformed but not validated.
     *
     * @param e the event encapsulating form data, page state and event source
     * @throws FormProcessException to signal that further processing of the
     * form should be aborted.
     */
    void submitted(FormSectionEvent e) throws FormProcessException;

}
