/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.FormProcessException;
import java.util.EventListener;

/**
 *    Defines the interface for a class that performs a processing step
 *    on valid data.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormProcessListener.java#8 $
 */

public interface FormProcessListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormProcessListener.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Performs a processing step on the data in the
     * <code>FormData</code> object.
     *
     * <p>Implementations of this method are responsible for catching
     * specific exceptions that may occur during processing, and either
     * handling them internally or rethrowing them as instances of
     * <code>FormProcessException</code> to be handled by the calling
     * procedure.
     *
     * <p>Implementations of this method cannot assume success or
     * failure of other FormProcessListeners associated with a
     * particular FormModeel. Each implementation must act independently
     *
     * @param model The form model describing the structure and properties
     * of the form data included with this request.
     *
     * @param data The container for all data objects associated with
     * the request.  String values for all parameters specified in the
     * form model are converted to Java data objects and validated
     * before processing occurs.
     *
     * @param request The HTTP request information from which the form
     * data was extracted.  Note that the request object is supplied
     * only in case the processing step requires contextual information
     * (information extracted from cookies or the peer address, for
     * example) or needs to modify session properties.
     *
     * @param response The HTTP response that will be returned to the
     * user.  The processing step may require access to this object to
     * set cookies or handle errors. */

    void process(FormSectionEvent e) throws FormProcessException;

}
